/*
 * @(#)PolygonIcon.java   1.4  2003-04-21
 *
 * Copyright (c) 1999 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.randelshofer.gui;

import java.awt.*;
import javax.swing.*;
/**
 * An Icon which is composed of java.awt.Polygon's.
 *
 * @author  Werner Randelshofer, Staldenmattweg 2, CH-6405 Immensee, Switzerland
 *
 * @version 1.4 2003-04-21 Method setFillPolygon add.
 * <br>1.3.2 2001-08-14 Comments added.
 * <br>1.3.1 2001-08-02 Method setFillColor added.
 * <br>1.3 2001-07-24 Upgraded for JDK 1.3.
 * <br>1.2    2001-02-27  When the component is disabled,
 * the polygon is drawn in gray.
 * <br>  1999-05-13  Polygons are stroked and filled to provide
 *           better visual compatibility on various Java VM's.
 * <br>  1999-05-02  Support added for array of polygons.
 * <br>  1999-02-14 Created.
 */
public class PolygonIcon
implements Icon {
    private Polygon[] polygons;
    private Dimension size;
    private Color color;
    private Color fillColor;
    private boolean isFilled = true;
    
    /**
     * Creates a new icon.
     *
     * @param p An Array of polygons.
     * @param size The fixed width/height of the icon.
     */
    public PolygonIcon(Polygon[] p, Dimension size) {
        polygons = p;
        this.size = size;
    }
    /**
     * Creates a new icon.
     *
     * @param p The polygon.
     * @param size The fixed width/height of the icon.
     */
    public PolygonIcon(Polygon p, Dimension size) {
        polygons = new Polygon[] { p };
        this.size = size;
    }
    /**
     * Sets the fill color of the polygons.
     *
     * @param color The fill color.
     *              If this is null, the polygons are filled
     *              with the foreground color.
     */
    public void setFillColor(Color color) {
        fillColor = color;
    }
    
    public void setFilled(boolean b) {
        isFilled = b;
    }
    
    /**
     * Sets the foreground color of the polygons.
     *
     * @param color The foreground color.
     *              If this is null, the polygons are filled
     *              with the foreground color of the Component
     *              hosting the icon.
     */
    public void setForeground(Color color) {
        this.color = color;
    }
    /**
     * Draws the icon at the specified location. Icon implementations
     * may use the Component argument to get properties useful for
     * painting, e.g. the foreground or background color.
     */
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color borderColor = (c.isEnabled())
        ? ((color != null) ? color : c.getForeground())
        : Color.gray;
        
        g.setColor(borderColor);
        g.translate(x,y);
        if (polygons != null) {
            for (int i=0; i < polygons.length; i++) {
                if (isFilled) {
                    if (fillColor != null) {
                        g.setColor(fillColor);
                        g.fillPolygon(polygons[i]);
                        g.setColor(borderColor);
                    } else {
                        g.fillPolygon(polygons[i]);
                    }
                }
                g.drawPolygon(polygons[i]);
            }
        }
        g.translate(-x,-y);
    }
    
    /**
     * Gets the width of the icon.
     *
     * @return The fixed width of the icon.
     */
    public int getIconWidth() {
        return size.width;
    }
    
    /**
     * Gets the height of the icon.
     *
     * @return The fixed height of the icon.
     */
    public int getIconHeight() {
        return size.height;
    }
}
